/* ES11 ECMAScript 2020 Features
1. Dynamic Import
2. BigInt
3. Private Class Variables
4. Promise.allSettled
5. Optional Chaining Operator  
*/
//BigInt
let oldNumber = Number.MAX_SAFE_INTEGER;
console.log(oldNumber);

console.log(oldNumber+1);
console.log(oldNumber+2);
console.log(oldNumber+10);
let newNumb = BigInt(oldNumber);
console.log(newNumb);

//3. Private Class Variables

class Student{
    constructor (){

    }
    #born = 1987;
    calcAge(){
        console.log(2020 - this.#born);
    }
}

const student  = new Student();
student.calcAge();
//console.log(student.#born);

//4.Promise.allSettled

//ES6 Promise.all

const promiseOne = new Promise((resolve,reject)=>{
    setTimeout(resolve,500,'promise 1');
});
const promiseTwo = new Promise((resolve,reject)=>{
    setTimeout(reject,1000,'promise 2');
});
const promiseThree = new Promise((resolve,reject)=>{
    setTimeout(resolve,2000,'promise 3');
});

// Promise.all([promiseOne,promiseTwo,promiseThree]).then(data=>{
//     console.log(data);
// }).catch(error =>{
//     console.log('Error happened! '+error);
// });
Promise.allSettled([promiseOne,promiseTwo,promiseThree]).then(data=>{
    console.log(data);
}).catch(error =>{
    console.log('Error happened! '+error);
});

//5. Optional Chaining Operator
const adventurer = {
    name:'Rick',
    cat :{
        name:'Cat'
    }
};
//const dogName = adventurer.dog.name;
const dogName = adventurer.dog?.name;
//adventurer.someNonExistentMethod();

console.log(adventurer.someNonExistentMethod?.())